VERSION ("Time 1.0")

'***************************************************************************************************************************
'
'  Sample Program for Calendar and Timer Commands
'
'  Target Machine : CPT-711
'
'  Commands :
'	ON TIMER(N%, duration) GOSUB SubLabel : 	To activate the "TIMER Event Trigger which executes a specific 
'						            subroutine when the system runs out the time duration that was 
'							specified by the user.
'
'	DATE$ = X$ - To set the current date.		"X$ is in the form of "yyyymmdd .
'	Y$ = DATE$ - To get the current date.		"Y$ is a valid string variable.
'
'	TIME$ = X$ - To set the current time.		"X$ is in the form of  hhmmss .
'	Y$ = TIME$ - To get the current time.		"Y$ is a valid string variable.
'
'	A% = DAY_OF_WEEK : To get the day of the week.
'
'	OFF TIMER(N%) : To terminate the TIMER Event Trigger specified by the ON command
'			     TIMERK GOSUBK command.
'
'	WAIT(duration%) : Put the system on hold for the specified time duration. During this period, the system 
'			     will be running in a special low-power-consumption mode.	
'
'**************************************************************************************************************************


'*********     Constants     **********
	DisplayFlag% = 1

	ON TIMER(1,1000) GOSUB SetTime

MainStart:
	IF DisplayFlag% = 1 THEN
		CLS	
		LOCATE 1,1
		PRINT "CALENDAR & TIMER"	
		DisplayFlag% = 0
	END IF	

	TodayD$ = DATE$
	LOCATE 3,1
	PRINT "DATE:"; LEFT(TodayD$,4); "/"; MID$(TodayD$,5,2); "/"; RIGHT$(TodayD$,2)

	TodayT$ = TIME$
	LOCATE 5,1
	PRINT "TIME:"; LEFT$(TodayT$,2); ":"; MID$(TodayT$,3,2); ":"; RIGHT$(TodayT$,2)

	LOCATE 7,1
	DayWeek% = DAY_OF_WEEK
	ON DayWeeK% GOSUB 100, 200, 300, 400, 500, 600, 700
	GOTO MainStart


SetTime:
	OFF TIMER(1)
	BEEP(2000,5,0,10,3000,10)

	CLS
	LOCATE 1,3
	PRINT "SET DATE & TIME."

	LOCATE 7,1
	PRINT STRING$(20," ")

	LOCATE 3,3
	PRINT "DATE:"; DATE$

	LOCATE 5,3
	PRINT "TIME:"; TIME$

	CURSOR(1)

	LOCATE 4,8
	INPUT SetDate$
	DATE$ = SetDate$

	LOCATE 6,8
	INPUT SetTime$
	TIME = SetTime$	

	CURSOR(0)
	DisplayFlag% = 1

	LOCATE 8,2
	PRINT "Wait 5 sec, RETURN"
	WAIT(500)
	BEEP(2000,5)	
	RETURN


100
	PRINT "Today is Monday."
	RETURN
200
	PRINT "Today is Tuesday."
	RETURN
300
	PRINT "Today is Wednesday."
	RETURN	
400
            PRINT "Today is Thursday."
            RETURN
500
            PRINT "Today is Friday."
            RETURN
600
	PRINT "Today is Saturday."
            RETURN
700
	PRINT "Today is Sunday."
            RETURN